/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.LogWriter;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;

public class SubGuiColorSelector
extends SubGuiInterface
implements ITextfieldListener,
ISliderListener {
    private static final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/color.png");
    protected final BufferedImage bufferedimage;
    public int color;
    private int colorX;
    private int colorY;
    private GuiNpcTextField textfield;
    protected ColorCallback callback;
    protected boolean hoverTexture;
    protected boolean hasAlpha = false;
    protected float alpha = 1.0f;
    protected int offsetX = 0;
    protected GuiNpcSlider alphaSlider;
    protected GuiNpcTextField alphaField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubGuiColorSelector(int colorInt) {
        this.xSize = 176;
        this.ySize = 222;
        this.setBackground("smallbg.png");
        this.color = colorInt;
        if (this.field_146297_k == null) {
            this.field_146297_k = Minecraft.func_71410_x();
        }
        InputStream stream = null;
        BufferedImage buffer = null;
        try {
            IResource iresource = this.field_146297_k.func_110442_L().func_110536_a(resource);
            stream = iresource.func_110527_b();
            buffer = ImageIO.read(stream);
        }
        catch (IOException e) {
            LogWriter.error(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    LogWriter.error(ex);
                }
            }
        }
        this.bufferedimage = buffer;
    }

    public SubGuiColorSelector(int colorIn, ColorCallback callbackIn) {
        this(colorIn);
        this.callback = callbackIn;
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guibutton) {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 66) {
            this.close();
        }
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        float alpha;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_146297_k.func_110434_K().func_110577_a(resource);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.colorX, this.colorY, 0, 0, 120, 120);
        boolean bl = this.hoverTexture = !((double)mouseX < (double)this.colorX || (double)mouseX > (double)(this.colorX + 117) || (double)mouseY < (double)this.colorY || (double)mouseY > (double)(this.colorY + 117));
        if (this.textfield == null) {
            return;
        }
        int x = this.textfield.field_146209_f + this.textfield.field_146218_h + 5;
        int y = this.textfield.field_146210_g;
        int c = new Color(-8355712).getRGB();
        SubGuiColorSelector.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 41), (int)(y + 21), (int)c);
        c = this.color;
        if (!this.textfield.func_146206_l()) {
            if (this.bufferedimage != null && this.hoverTexture) {
                try {
                    c = new Color(this.bufferedimage.getRGB((int)((double)mouseX - (double)this.guiLeft - 30.0) * 4, (int)((double)mouseY - (double)this.guiTop - 50.0) * 4) & new Color(0xFFFFFF).getRGB()).getRGB();
                    StringBuilder str = new StringBuilder(Integer.toHexString(c));
                    while (str.length() < 6) {
                        str.insert(0, "0");
                    }
                    while (str.length() > 6) {
                        str.deleteCharAt(0);
                    }
                    this.textfield.setFullText(str.toString());
                }
                catch (Exception str) {}
            } else {
                this.textfield.setFullText(this.getColor());
            }
        }
        if (this.callback != null) {
            if (this.hasAlpha) {
                c = (int)(this.alpha * 255.0f) << 24 | c & 0xFFFFFF;
            }
            this.callback.preColor(c);
        }
        if ((alpha = (float)(c >> 24 & 0xFF) / 255.0f) == 0.0f) {
            c += new Color(-16777216).getRGB();
        }
        SubGuiColorSelector.func_73734_a((int)x, (int)y, (int)(x + 40), (int)(y + 20), (int)c);
    }

    public String getColor() {
        StringBuilder str = new StringBuilder(Integer.toHexString(this.color));
        while (str.length() < 6) {
            str.insert(0, "0");
        }
        return str.toString();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft += this.offsetX;
        this.colorX = this.guiLeft + 30;
        this.colorY = this.guiTop + 50;
        this.textfield = new GuiNpcTextField(0, this, this.guiLeft + 31, this.guiTop + 20, 70, 20, this.getColor());
        this.addTextField(this.textfield);
        this.textfield.func_146203_f(6);
        this.textfield.setHoverText("color.hover", new Object[0]);
        GuiNpcButton button = new GuiNpcButton(66, this.guiLeft + 112, this.guiTop + 198, 60, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        if (this.hasAlpha) {
            this.alpha = (float)(this.color >> 24 & 0xFF) / 255.0f;
            this.alphaSlider = new GuiNpcSlider(this, 0, this.guiLeft + 30, this.guiTop + 173, 84, 14, this.alpha);
            this.addSlider(this.alphaSlider);
            this.alphaSlider.setHoverText("color.alpha", new Object[0]);
            this.alphaField = new GuiNpcTextField(1, this, this.guiLeft + 117, this.guiTop + 170, 30, 20, "" + (int)(this.alpha * 255.0f));
            this.addTextField(this.alphaField);
            this.alphaField.setMinMaxDefault(0L, 255L, (int)(this.alpha * 255.0f));
            this.alphaField.setHoverText("color.alpha", new Object[0]);
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        String prev = this.textfield.func_146179_b();
        super.func_73869_a(c, i);
        String newText = this.textfield.func_146179_b();
        if (!newText.equals(prev)) {
            try {
                this.setColor(Integer.parseInt(newText, 16));
            }
            catch (NumberFormatException e) {
                this.textfield.func_146180_a(prev);
            }
        }
    }

    @Override
    public void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        if (this.bufferedimage == null || i < this.colorX || i > this.colorX + 117 || j < this.colorY || j > this.colorY + 117) {
            return;
        }
        this.setColor(this.bufferedimage.getRGB((i - this.guiLeft - 30) * 4, (j - this.guiTop - 50) * 4) & new Color(0xFFFFFF).getRGB());
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        if (textfield.getID() == 0) {
            try {
                this.setColor(Integer.parseInt(textfield.getFullText(), 16));
            }
            catch (NumberFormatException e) {
                textfield.setFullText(this.getColor());
            }
        } else if (textfield.getID() == 1) {
            this.alpha = (float)textfield.getInteger() / 255.0f;
            this.color = textfield.getInteger() << 24 | this.color & 0xFFFFFF;
            if (this.alphaSlider != null) {
                this.alphaSlider.setSliderValue(this.alpha);
            }
        }
    }

    private void setColor(int colorIn) {
        this.color = colorIn;
        this.textfield.setFullText(this.getColor());
        if (this.callback != null) {
            this.callback.color(this.color);
        }
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
        this.alpha = slider.getSliderValue();
        this.color = (int)(this.alpha * 255.0f) << 24 | this.color & 0xFFFFFF;
        if (this.alphaField != null) {
            this.alphaField.setFullText("" + (int)(this.alpha * 255.0f));
        }
    }

    @Override
    public void mousePressed(IGuiNpcSlider slider) {
    }

    @Override
    public void mouseReleased(IGuiNpcSlider slider) {
    }

    public SubGuiColorSelector setOffsetX(int posX) {
        this.offsetX = posX;
        return this;
    }

    public SubGuiColorSelector setIsAlpha() {
        this.hasAlpha = true;
        return this;
    }

    public static interface ColorCallback {
        public void color(int var1);

        public void preColor(int var1);
    }
}

